/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.model;

import com.sun.deploy.model.DeployCacheJarAccess;
import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceObject;
import com.sun.deploy.net.UpdateTracker;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;

public abstract class ResourceProvider {
    public static final int DOWNLOAD_NORMAL = 1;
    public static final int DOWNLOAD_NATIVE = 16;
    public static final int DOWNLOAD_JAR = 256;
    public static final int DOWNLOAD_PACK200 = 4096;
    public static final int DOWNLOAD_VERSION = 65536;
    private static final String BACKGROUND_STRING = "background";
    private static final String APPCONTEXT_BG_KEY = "deploy-bg-";
    protected static ResourceProvider instance;

    public static ResourceProvider get() {
        if (instance == null) {
            Trace.println("ResourceProvider not initialized", TraceLevel.CACHE);
            if (Trace.isEnabled(TraceLevel.CACHE)) {
                Trace.ignored(new Throwable("ResourceProvider not initialized"));
            }
        }
        return instance;
    }

    protected static synchronized void set(ResourceProvider resourceProvider) {
        if (instance == null) {
            Trace.println("Initialize resource manager: " + resourceProvider, TraceLevel.CACHE);
            instance = resourceProvider;
        } else {
            Trace.println("Attempt to reset resource manager", TraceLevel.CACHE);
            if (Trace.isEnabled(TraceLevel.CACHE)) {
                Trace.ignored(new Throwable("" + resourceProvider));
            }
        }
    }

    public abstract Resource getResource(URL var1, String var2, boolean var3, int var4, DownloadDelegate var5) throws IOException;

    public final Resource getResource(URL uRL, String string) throws IOException {
        return this.getResource(uRL, string, true, 1, null);
    }

    public final Resource getCachedResource(URL uRL, String string) {
        try {
            return this.getResource(uRL, string, false, 0, null);
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
            return null;
        }
    }

    public abstract String getCachedResourceFilePath(URL var1, String var2) throws IOException;

    public final File getCachedJNLPFile(URL uRL, String string) {
        try {
            Resource resource = this.getResource(uRL, string, false, 1, null);
            if (resource != null) {
                return resource.getDataFile();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public final boolean isCached(URL uRL, String string) {
        return this.getCachedResource(uRL, string) != null;
    }

    public final JarFile getJarFile(URL uRL, String string, int n) throws IOException {
        Resource resource = this.getResource(uRL, string, true, n, null);
        return resource != null ? resource.getJarFile() : null;
    }

    public final JarFile getCachedJarFile(URL uRL, String string) {
        Resource resource = this.getCachedResource(uRL, string);
        return resource != null ? resource.getJarFile() : null;
    }

    public abstract Resource getJreResource(URL var1, String var2, boolean var3, boolean var4, String var5) throws IOException;

    public abstract boolean isUpdateAvailable(URL var1, String var2, int var3, Map var4) throws IOException;

    public abstract boolean checkUpdateAvailable(URL var1, Resource var2, int var3, Map var4) throws IOException;

    public boolean isUpdateAvailable(URL uRL, String string) throws IOException {
        return this.isUpdateAvailable(uRL, string, 1, null);
    }

    public abstract Resource downloadUpdate(URL var1, String var2, int var3, boolean var4) throws IOException;

    public final Resource downloadUpdate(URL uRL, String string) throws IOException {
        return this.downloadUpdate(uRL, string, 1, true);
    }

    public abstract void markReady(Resource[] var1) throws IOException;

    public abstract void markRetired(Resource var1, boolean var2);

    public abstract File getShortcutImage(URL var1, String var2, boolean var3) throws IOException;

    public abstract String getLibraryDirForJar(String var1, URL var2, String var3) throws IOException;

    public abstract void preverifyCachedJar(URL var1, String var2, URLClassLoader var3);

    public abstract Resource getSystemResource(URL var1, String var2);

    public abstract int incrementInternalUse();

    public abstract void decrementInternalUse(int var1);

    public abstract void setBackgroundUpdateRequest(boolean var1);

    public abstract boolean isBackgroundUpdateRequest();

    public abstract void decrementsInternalUse(int var1);

    public abstract boolean isInternalUse();

    public abstract LocalApplicationProperties getLocalApplicationProperties(URL var1, String var2, boolean var3);

    public abstract boolean canCache(URL var1);

    public abstract File getCacheDir();

    public abstract String getCurrentVersion(URL var1);

    public abstract ResourceObject getResourceObject(String var1);

    public void storeAppContextBackgroundList(List list) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            if (string == null) continue;
            UpdateTracker.addPending(string);
            ToolkitStore.get().getAppContext().put(APPCONTEXT_BG_KEY + string, BACKGROUND_STRING);
        }
    }

    public void clearAppContextBackgroundList(List list) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            if (string == null) continue;
            ToolkitStore.get().getAppContext().remove(APPCONTEXT_BG_KEY + string);
        }
    }

    protected static boolean isInBackgroundUpdateCheckList(URL uRL) {
        String string = (String)ToolkitStore.get().getAppContext().get(APPCONTEXT_BG_KEY + uRL);
        return string != null && string.equals(BACKGROUND_STRING);
    }

    public abstract boolean hasEnhancedJarAccess();

    public abstract DeployCacheJarAccess getJarAccess();
}

